
# Inventory Transfer

Represents the transfer of a quantity of product inventory at a
particular time from one location to another.

## Structure

`InventoryTransfer`

## Fields

| Name | Type | Tags | Description | Getter | Setter |
|  --- | --- | --- | --- | --- | --- |
| `id` | `?string` | Optional | A unique ID generated by Square for the<br>`InventoryTransfer`.<br>**Constraints**: *Maximum Length*: `100` | getId(): ?string | setId(?string id): void |
| `referenceId` | `?string` | Optional | An optional ID provided by the application to tie the<br>`InventoryTransfer` to an external system.<br>**Constraints**: *Maximum Length*: `255` | getReferenceId(): ?string | setReferenceId(?string referenceId): void |
| `state` | [`?string (InventoryState)`](/doc/models/inventory-state.md) | Optional | Indicates the state of a tracked item quantity in the lifecycle of goods. | getState(): ?string | setState(?string state): void |
| `fromLocationId` | `?string` | Optional | The Square-generated ID of the [Location](/doc/models/location.md) where the related<br>quantity of items was tracked before the transfer.<br>**Constraints**: *Maximum Length*: `100` | getFromLocationId(): ?string | setFromLocationId(?string fromLocationId): void |
| `toLocationId` | `?string` | Optional | The Square-generated ID of the [Location](/doc/models/location.md) where the related<br>quantity of items was tracked after the transfer.<br>**Constraints**: *Maximum Length*: `100` | getToLocationId(): ?string | setToLocationId(?string toLocationId): void |
| `catalogObjectId` | `?string` | Optional | The Square-generated ID of the<br>[CatalogObject](/doc/models/catalog-object.md) being tracked.<br>**Constraints**: *Maximum Length*: `100` | getCatalogObjectId(): ?string | setCatalogObjectId(?string catalogObjectId): void |
| `catalogObjectType` | `?string` | Optional | The [type](/doc/models/catalog-object-type.md) of the<br>[CatalogObject](/doc/models/catalog-object.md) being tracked.Tracking is only<br>supported for the `ITEM_VARIATION` type.<br>**Constraints**: *Maximum Length*: `14` | getCatalogObjectType(): ?string | setCatalogObjectType(?string catalogObjectType): void |
| `quantity` | `?string` | Optional | The number of items affected by the transfer as a decimal string.<br>Can support up to 5 digits after the decimal point.<br>**Constraints**: *Maximum Length*: `26` | getQuantity(): ?string | setQuantity(?string quantity): void |
| `occurredAt` | `?string` | Optional | A client-generated RFC 3339-formatted timestamp that indicates when<br>the transfer took place. For write actions, the `occurred_at` timestamp<br>cannot be older than 24 hours or in the future relative to the time of the<br>request.<br>**Constraints**: *Maximum Length*: `34` | getOccurredAt(): ?string | setOccurredAt(?string occurredAt): void |
| `createdAt` | `?string` | Optional | An RFC 3339-formatted timestamp that indicates when Square<br>received the transfer request.<br>**Constraints**: *Maximum Length*: `34` | getCreatedAt(): ?string | setCreatedAt(?string createdAt): void |
| `source` | [`?SourceApplication`](/doc/models/source-application.md) | Optional | Provides information about the application used to generate a change. | getSource(): ?SourceApplication | setSource(?SourceApplication source): void |
| `employeeId` | `?string` | Optional | The Square-generated ID of the [Employee](/doc/models/employee.md) responsible for the<br>inventory transfer.<br>**Constraints**: *Maximum Length*: `100` | getEmployeeId(): ?string | setEmployeeId(?string employeeId): void |

## Example (as JSON)

```json
{
  "id": "id0",
  "reference_id": "reference_id2",
  "state": "SUPPORTED_BY_NEWER_VERSION",
  "from_location_id": "from_location_id2",
  "to_location_id": "to_location_id8"
}
```

