<?php

namespace League\Glide\Manipulators;

use Mockery;

class SharpenTest extends \PHPUnit_Framework_TestCase
{
    private $manipulator;

    public function setUp()
    {
        $this->manipulator = new Sharpen();
    }

    public function tearDown()
    {
        Mockery::close();
    }

    public function testCreateInstance()
    {
        $this->assertInstanceOf('League\Glide\Manipulators\Sharpen', $this->manipulator);
    }

    public function testRun()
    {
        $image = Mockery::mock('Intervention\Image\Image', function ($mock) {
            $mock->shouldReceive('sharpen')->with('10')->once();
        });

        $this->assertInstanceOf(
            'Intervention\Image\Image',
            $this->manipulator->setParams(['sharp' => '10'])->run($image)
        );
    }

    public function testGetPixelate()
    {
        $this->assertSame(10, $this->manipulator->setParams(['sharp' => '10'])->getSharpen());
        $this->assertSame(50, $this->manipulator->setParams(['sharp' => 50.5])->getSharpen());
        $this->assertSame(null, $this->manipulator->setParams(['sharp' => null])->getSharpen());
        $this->assertSame(null, $this->manipulator->setParams(['sharp' => 'a'])->getSharpen());
        $this->assertSame(null, $this->manipulator->setParams(['sharp' => '-1'])->getSharpen());
        $this->assertSame(null, $this->manipulator->setParams(['sharp' => '101'])->getSharpen());
    }
}
